package com.example.sefinsa_app.migrations;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

import com.example.sefinsa_app.models.ConfiguracionSemana;
import com.example.sefinsa_app.models.Ruta;

public class ConfiguracionSemanasMigration extends SQLiteOpenHelper {
    private static final String NOMBRE_BASE_DE_DATOS = "sefinsa_proyecto2",
    //private static final String NOMBRE_BASE_DE_DATOS = "sefinsa_test",
    NOMBRE_TABLA = "configuracion_semanas";
    private static final int VERSION_BASE_DE_DATOS = 12;

    public ConfiguracionSemanasMigration(Context context) {
        super(context, NOMBRE_BASE_DE_DATOS, null, VERSION_BASE_DE_DATOS);
        SQLiteDatabase db = this.getWritableDatabase();
    }

    @Override
    public void onCreate(SQLiteDatabase db) {

        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(" +
                        "id integer primary key, " +
                        "cantidad int, " +
                        "interes text, " +
                        "tipo_abono text, " +
                        "semana_renovacion int, " +
                        "status int) "
                , NOMBRE_TABLA);

        db.execSQL(TABLE_SCHEMA);

    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL(String.format("DROP TABLE IF EXISTS " + NOMBRE_TABLA));
        onCreate(db);
    }
    @Override
    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        // Manejo personalizado de "downgrade", por ejemplo, eliminar la base de datos
        db.execSQL("DROP TABLE IF EXISTS " + NOMBRE_TABLA);
        onCreate(db);
    }
    public void deleteAllConfiguracionSemana() {
        SQLiteDatabase db = this.getWritableDatabase();
        db.execSQL("DELETE FROM configuracion_semanas");
        db.close();
    }
    public boolean doesConfiguracionSemanaExist(SQLiteDatabase db, String id) {
        String query = "SELECT COUNT(*) FROM " + NOMBRE_TABLA + " WHERE id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{id});
        boolean exists = false;

        if (cursor != null) {
            cursor.moveToFirst();
            exists = cursor.getInt(0) > 0;
            cursor.close();
        }

        return exists;
    }

    public ConfiguracionSemana getConfiguracionSemanaById(SQLiteDatabase db, String id) {
        String query = "SELECT id, cantidad, interes, tipo_abono, semana_renovacion, status  FROM " + NOMBRE_TABLA + " WHERE id = ?";
        Log.d("getRutaById", "Ejecutando consulta: " + query + " con id: " + id);

        Cursor cursor = db.rawQuery(query, new String[]{id});
        ConfiguracionSemana configuracionsemana = null;

        if (cursor != null && cursor.moveToFirst()) {
            Log.d("getClienteById", "Cursor movido a la primera posición. Leyendo datos...");
            String id2 = cursor.getString(0);
            String cantidad = cursor.getString(1);
            String interes = cursor.getString(2);
            String tipo_abono = cursor.getString(3);
            String semana_renovacion = cursor.getString(4);
            String status = cursor.getString(5);

            // Construir el objeto Cliente
            configuracionsemana = new ConfiguracionSemana(id2, cantidad, interes, tipo_abono, semana_renovacion, status);

            cursor.close();
        } else {
            Log.e("getClienteById", "No se encontró ningún registro con el id: " + id);
        }

        return configuracionsemana;
    }

    public void updateConfiguracionSemanaInSQLite(SQLiteDatabase db, ConfiguracionSemana configuracionSemana) {
        ContentValues values = new ContentValues();
        values.put("id", configuracionSemana.getId());
        values.put("cantidad", configuracionSemana.getCantidad());
        values.put("interes", configuracionSemana.getInteres());
        values.put("tipo_abono", configuracionSemana.getTipo_Abono());
        values.put("semana_renovacion", configuracionSemana.getSemana_Renovacion());
        values.put("status", configuracionSemana.getStatus());

        // Actualizar el registro
        db.update(NOMBRE_TABLA, values, "id = ?", new String[]{configuracionSemana.getId()});
    }
}
